<?php
function WC_Zardis_Message($result){
	$msg='';
	if($result->status){
		$msg = 'تراکنش موفقیت آمیز بوده است';
	}else{
		$msg = $result->errorCode.' - '.$result->errorDescription;
	}

	return $msg;
}

function WC_Zardis_pay($api_key, $amount, $redirect) {
    $params = ['api_key' => $api_key,'amount' => $amount,'return_url' => $redirect];
    try {
        $number_of_connection_tries = 5;
        $response = null;
        while ($number_of_connection_tries > 0) {
            $response = wp_remote_post('https://pay.zardis.net/invoice/request', array(
                'body' => $params,
                'headers' => array('Content-Type' => 'application/x-www-form-urlencoded'),
                'method_post' => 'POST',
                'timeout'       => 60,
            ));
            if (is_wp_error($response)) {
                $number_of_connection_tries--;
                continue;
            } else {
                break;
            }
        }

        $body = wp_remote_retrieve_body($response);
        return $body;
    } catch (Exception $ex) {
        return [];
    }
}

function WC_Zardis_verify($api_key, $inv_key) {
    $params = ['api_key' => $api_key];
     try {
        $number_of_connection_tries = 5;
        $response = null;
        while ($number_of_connection_tries > 0) {
            $response = wp_safe_remote_post('https://pay.zardis.net/invoice/check/'.$inv_key, array(
                'body' => $params,
                'headers' => array('Content-Type' => 'application/x-www-form-urlencoded'),
            ));
            if (is_wp_error($response)) {
                $number_of_connection_tries--;
                continue;
            } else {
                break;
            }
        }

        $body = wp_remote_retrieve_body($response);

        return $body;
    } catch (Exception $ex) {
        return [];
    }
}




add_action('plugins_loaded', 'woocommerce_Zardis_init', 0);

function woocommerce_Zardis_init() 
{
    if (!class_exists( 'WC_Payment_Gateway' ) ) return;
	
	function ZardisWOO_Add($methods) {
		$methods[] = 'ZardisWOO';
		return $methods;
	}
	add_filter('woocommerce_payment_gateways', 'ZardisWOO_Add');	
	
	add_filter('woocommerce_currencies', 'add_IR_currency_Zardis');

	function add_IR_currency_Zardis($currencies) {
		$currencies['IRR'] = __('ریال', 'woocommerce');
		$currencies['IRT'] = __('تومان', 'woocommerce');
		$currencies['IRHR'] = __('هزار ریال', 'woocommerce');
		$currencies['IRHT'] = __('هزار تومان', 'woocommerce');

		return $currencies;
	}

	add_filter('woocommerce_currency_symbol', 'add_IR_currency_Zardis_symbol', 10, 2);

	function add_IR_currency_Zardis_symbol($currency_symbol, $currency) {
		switch ($currency) {
			case 'IRR': $currency_symbol = 'ریال';
				break;
			case 'IRT': $currency_symbol = 'تومان';
				break;
			case 'IRHR': $currency_symbol = 'هزار ریال';
				break;
			case 'IRHT': $currency_symbol = 'هزار تومان';
				break;
		}
		return $currency_symbol;
	}
	
	class ZardisWOO extends WC_Payment_Gateway {
		public function __construct(){
			  $this->id = 'Zardis';
			  $this->id = 'zardis';
			  $this->method_title = 'درگاه پرداخت زردیس پی';
			  $this->method_description = 'پرداخت امن بوسیله کلیه کارت های عضو شتاب';				
			  $this->has_fields = false;
			  $this->init_form_fields();
			  $this->init_settings();
			  $this->title = $this->settings['title'];
			  $this->api=$this->settings['api'];
			  $this->msg_Success=$this->settings['msg_Success'];
			  $this->msg_Unsuccessful=$this->settings['msg_Unsuccessful'];
			  
			  if ( version_compare( WOOCOMMERCE_VERSION,'2.0.0', '>=')){
				  add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
			  } else {
				  add_action( 'woocommerce_update_options_payment_gateways', array( $this, 'process_admin_options' ) );
			  }	
			  add_action('woocommerce_api_'.strtolower(get_class($this)).'', array($this, 'ZardisWOO_Response'));
			  add_action('woocommerce_receipt_zardis', array($this, 'ZardisWOO_Request'));
		}
				
		public function init_form_fields(){
			$this->form_fields = array(
               		'enabled' => array(
						'title' => 'وضعیت درگاه',
						'type' => 'checkbox',
						'label' => 'فعال سازی/غیر فعال سازی',
						'default' => 'yes'
					),
					'title' => array(
						'title'       => 'عنوان درگاه',
						'type'        => 'text',
						'default'     => 'Zardis',
					),
					'description' => array(
						'title'       => 'توضیحات درگاه',
						'type'        => 'text',
						'default'     => 'درگاه پرداخت Zardis',
					),
					'api' => array(
						'title'       => 'API Zardis',
						'type'        => 'text',
					),
					'msg_Success' => array(
						'title'       => 'پیام پرداخت موفق',
						'type'        => 'textarea',
						'description' => 'متن پیامی که میخواهید بعد از پرداخت موفق به کاربر نمایش دهید را وارد نمایید . <br>
همچنین می توانید از شورت کد {transaction_id} برای نمایش کد رهگیری ( کد مرجع تراکنش ) و از شرت کد {SaleOrderId} برای شماره درخواست تراکنش استفاده نمایید .',
						'default'     => 'با تشکر از شما . سفارش شما با موفقیت پرداخت شد . <br> شماره رهگیری : {transaction_id}',
					),
					'msg_Unsuccessful' => array(
						'title'       => 'پیام پرداخت ناموفق',
						'type'        => 'textarea',
						'description' =>'متن پیامی که میخواهید بعد از پرداخت ناموفق به کاربر نمایش دهید را وارد نمایید .<br>
همچنین می توانید از شورت کد {fault} برای نمایش دلیل خطای رخ داده استفاده نمایید.',
						'default'     => 'پرداخت شما ناموفق بوده است . لطفا مجددا تلاش نمایید یا در صورت بروز اشکال با مدیر سایت تماس بگیرید .'
					),
				);
		}
		public function admin_options()
		{
			echo '<h3>تنظیمات درگاه پرداخت Zardis</h3>';
			echo '<table class="form-table">';
			$this->generate_settings_html();
			echo '</table>';
		}
		
		public function ZardisWOO_Response()
		{
			global $woocommerce;
			$order_id = $woocommerce->session->order_id;
			if (!$order_id) $order_id = $_GET['order_id'];
			$order = new WC_Order($order_id);
			if($order_id != '')
			{
				$_Msg=array();

				if($order->status !='completed')
				{
					$transid = isset($_POST['invoice_key'])?$_POST['invoice_key']:'';
					update_post_meta($order_id, 'WC_Zardis_transid', $transid);
					$result = WC_Zardis_verify($this->api,$transid);
					$result = json_decode($result);

					if($result->status)
					{
						$currency = $order->get_order_currency();
						$currency = apply_filters('WC_Zardis_Currency', $currency, $order_id);
						$amount = str_replace(".00", "", $result->amount); //rial
						if (strtolower($currency) == strtolower('IRT') || strtolower($currency) == strtolower('TOMAN') || strtolower($currency) == strtolower('Iran TOMAN') || strtolower($currency) == strtolower('Iranian TOMAN') || strtolower($currency) == strtolower('Iran-TOMAN') || strtolower($currency) == strtolower('Iranian-TOMAN') || strtolower($currency) == strtolower('Iran_TOMAN') || strtolower($currency) == strtolower('Iranian_TOMAN') || strtolower($currency) == strtolower('تومان') || strtolower($currency) == strtolower('تومان ایران'))
							$order->order_total = $order->order_total * 10;
						else if (strtolower($currency) == strtolower('IRHT'))
							$order->order_total = $order->order_total * 10000;
						else if (strtolower($currency) == strtolower('IRHR'))
							$order->order_total = $order->order_total * 1000;
						else if (strtolower($currency) == strtolower('IRR'))
							$order->order_total = $order->order_total / 1;
						
						if($amount == $order->order_total){
							@session_start();
							$params['token'] =  $_SESSION['token'];
							$_Msg['message'] = "پرداخت شما با موفقیت انجام شد<br/> کد ارجاع : $transid";
							$_Msg['class'] = 'success';
							$order->payment_complete();
							$order->add_order_note($_Msg['message']);
							$woocommerce->cart->empty_cart();
							
							$Note = sprintf( __('پرداخت موفقیت آمیز بود .<br/> کد رهگیری (کد مرجع تراکنش) : %s <br/> شماره درخواست تراکنش : %s', 'woocommerce' ), $transid ,'');
							$order->add_order_note($Note , 1);
							$Notice = wpautop(wptexturize($this->msg_Success));						
							$Notice = str_replace("{transaction_id}" ,$transid ,$Notice);
							// $Notice = str_replace("{SaleOrderId}" ,$transid ,$Notice);
							wc_add_notice( $Notice , 'success');
							wp_redirect( add_query_arg( 'wc_status', 'success', $this->get_return_url( $order ) ) );
							exit;
						}else{
							$Note = sprintf( __('عدم تطابق مبلغ پرداختی : %s %s %s', 'woocommerce'),$amount.' <> '.$order->order_total, '<br/>کد رهگیری (کد مرجع تراکنش) : '.$transid , '');
							$order->add_order_note( $Note , 1 );						
							$Notice = wpautop( wptexturize($this->msg_Unsuccessful));
							$Notice = str_replace("{transaction_id}",$transid,$Notice);
							// $Notice = str_replace("{SaleOrderId}",$getid,$Notice);
							$Notice = str_replace("{fault}",WC_Zardis_Message($result),$Notice);
							wc_add_notice( $Notice , 'error' );
							wp_redirect(  $woocommerce->cart->get_checkout_url()  );
							exit;
						}
					}
					else
					{		
						$Note = sprintf( __('خطا در هنگام بازگشت از بانک : %s %s %s', 'woocommerce'),WC_Zardis_Message($result), '<br/>کد رهگیری (کد مرجع تراکنش) : '.$transid , '');
						$order->add_order_note( $Note , 1 );						
						$Notice = wpautop( wptexturize($this->msg_Unsuccessful));
						$Notice = str_replace("{transaction_id}",$transid,$Notice);
						// $Notice = str_replace("{SaleOrderId}",$getid,$Notice);
						$Notice = str_replace("{fault}",WC_Zardis_Message($result),$Notice);
						wc_add_notice( $Notice , 'error' );
						wp_redirect(  $woocommerce->cart->get_checkout_url()  );
						exit;
					}
				}
				else
				{
					$transid = get_post_meta( $order_id, 'WC_Zardis_transid', true);		
					// $getid = get_post_meta( $order_id, 'WC_Zardis_getid', true);
					$Notice = wpautop(wptexturize($this->msg_Success));
					$Notice = str_replace("{transaction_id}",$transid,$Notice);
					// $Notice = str_replace("{SaleOrderId}",$getid,$Notice);					
					wc_add_notice($Notice , 'success');					
					wp_redirect( add_query_arg( 'wc_status', 'success', $this->get_return_url( $order ) ) );
					exit;
				}
			}
			else
			{				
				$Notice = __('شماره سفارش وجود ندارد .', 'woocommerce');
				wc_add_notice($Notice , 'error');
				wp_redirect($woocommerce->cart->get_checkout_url());
				exit;
				
			}
		}
		
		function process_payment($order_id)
		{
			$order = new WC_Order($order_id);
			return array('result' => 'success', 'redirect' => $order->get_checkout_payment_url( true )); 
		}
		
		public function ZardisWOO_Request($order_id)
		{
			global $woocommerce;
			$mode = true;
			$order = new WC_Order($order_id);
			$currency = $order->get_order_currency();
			$currency = apply_filters('WC_Zardis_Currency', $currency, $order_id);
			
			$redirect_url = ($this->redirect_page_id=="" || $this->redirect_page_id==0)?get_site_url() . "/":get_permalink($this->redirect_page_id);
			$redirect_url = add_query_arg( 'wc-api', get_class( $this ), $redirect_url );
			$redirect_url = add_query_arg( 'order_id', $order_id, $redirect_url );
			$redirect_url = urlencode($redirect_url);
			unset( $woocommerce->session->order_id );
			$woocommerce->session->order_id = $order_id;
			$amount = str_replace(".00", "", $order->order_total); //rial
			if (strtolower($currency) == strtolower('IRT') || strtolower($currency) == strtolower('TOMAN') || strtolower($currency) == strtolower('Iran TOMAN') || strtolower($currency) == strtolower('Iranian TOMAN') || strtolower($currency) == strtolower('Iran-TOMAN') || strtolower($currency) == strtolower('Iranian-TOMAN') || strtolower($currency) == strtolower('Iran_TOMAN') || strtolower($currency) == strtolower('Iranian_TOMAN') || strtolower($currency) == strtolower('تومان') || strtolower($currency) == strtolower('تومان ایران'))
				$amount = $amount * 10;
			else if (strtolower($currency) == strtolower('IRHT'))
				$amount = $amount * 10000;
			else if (strtolower($currency) == strtolower('IRHR'))
				$amount = $amount * 1000;
			else if (strtolower($currency) == strtolower('IRR'))
				$amount = $amount / 1;
				
			$form = apply_filters( 'WC_Zardis_Form', $form, $order_id, $woocommerce );	
			do_action( 'WC_Zardis_Before_Form', $order_id, $woocommerce );	
			echo $form;
			do_action( 'WC_Zardis_After_Form', $order_id, $woocommerce );
            sleep(1);
			$result = WC_Zardis_pay($this->api, $amount, $redirect_url);
			$result = json_decode($result);
				if($result->status) {
					$go = "https://pay.zardis.net/invoice/pay/$result->invoice_key";
					if (!headers_sent()) {
						header('Location:'.$go);
						die;
					} else {
						echo "<script type='text/javascript'>window.onload=function (){top.location.href='".$go."';};</script>";
						exit;
					}
				} else {
					$Note = sprintf( __( 'خطا در هنگام ارسال به بانک : %s', 'woocommerce'), WC_Zardis_Message($result));
					$Note = apply_filters( 'WC_Request_Failed_Note', $Note, $order_id, $result->errorMessage);
					$order->add_order_note( $Note );
					$Notice = sprintf( __( 'در هنگام اتصال به بانک خطای زیر رخ داده است : <br/>%s', 'woocommerce'),WC_Zardis_Message($result));
					$Notice = apply_filters( 'WC_Request_Failed_Notice', $Notice, $order_id, $result->errorMessage);
					if ($Notice){
						wc_add_notice( $Notice , 'error' );
					}
					do_action('WC_Request_Failed', $order_id, $fault);
				}
			 
		}
	}//-Class
}

?>