<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}


function zardis_MetaData()
{
    return array(
        'DisplayName' => 'zardis',
        'APIVersion' => '1.0', // Use API Version 1.0
        'DisableLocalCredtCardInput' => true,
        'TokenisedStorage' => false,
    );
}


function zardis_config()
{
    return array(
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'پرداخت آنلاین با درگاه پرداخت zardis',
        ),
        'api' => array(
            'FriendlyName' => 'API Key',
            'Type' => 'password',
            'Default' => '',
            'Description' => 'API Key دریافتی شما از درگاه پرداخت zardis',
        ),
        'currencies' => array(
            'FriendlyName' => 'واحد پول سیستم',
            'Type' => 'dropdown',
            'Options' => array(
                'rial' => 'ریال',
                'toman' => 'تومان',
            ),
            'Description' => '',
        ),
    );
}

/**
 * Payment link.
 *
 * Required by third party payment gateway modules only.
 *
 * Defines the HTML output displayed on an invoice. Typically consists of an
 * HTML form that will take the user to the payment gateway endpoint.
 *
 * @param array $params Payment Gateway Module Parameters
 *
 * @return string
 */
function zardis_link($params)
{
    $currencies = $params['currencies'];

    $invoiceId = $params['invoiceid'];

    $amount = $params['amount'];
    $amount = (int) strtok($amount,'.');
    if($currencies=='toman')   $amount = $amount*10;

    $systemUrl = $params['systemurl'];
    $langPayNow = $params['langpaynow'];
    $moduleName = $params['paymentmethod'];
    $whmcsVersion = $params['whmcsVersion'];

    $url = 'https://pay.zardis.net/invoice/pay';

    $postfields = array();
    $postfields['invoice_id'] = $invoiceId;
    $postfields['amount'] = $amount;
    $postfields['callback_url'] = $systemUrl . '/modules/gateways/callback/' . $moduleName . '.php';

    $htmlOutput = '<form method="post" action="' . $systemUrl . '/' . $moduleName . '_pay.php' . '">';
    foreach ($postfields as $k => $v) {
        $htmlOutput .= '<input type="hidden" name="' . $k . '" value="' . urlencode($v) . '" />';
    }
    $htmlOutput .= '<input type="submit" value="' . $langPayNow . '" />';
    $htmlOutput .= '</form>';

    return $htmlOutput;
}
