<?php
$pluginData[Zardis][type] = 'payment';
$pluginData[Zardis][name] = 'درگاه پرداخت زردیس';
$pluginData[Zardis][uniq] = 'Zardis';
$pluginData[Zardis][description] = '';
$pluginData[Zardis][author][name] = 'Zardis';
$pluginData[Zardis][author][url] = 'https://pay.zardis.net/';
$pluginData[Zardis][author][email] = 'pay@zardis.net';
$pluginData[Zardis][field][config][1][title] = 'لطفا API_KEY خود را در فیلد زیر وارد نمایید ';
$pluginData[Zardis][field][config][1][name] = 'api_key';

    
function Zardis_pay($api_key, $amount, $redirect){
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,'https://pay.zardis.net/invoice/request');
    curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key&amount=$amount&return_url=$redirect");
    curl_setopt($ch,CURLOPT_POST,true);
    curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
    curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}

function Zardis_verify($api_key, $inv_key){
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,'https://pay.zardis.net/invoice/check/'.$inv_key);
    curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key");
    curl_setopt($ch,CURLOPT_POST,true);
    curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
    curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}

function gateway__Zardis($data)
{
    global $config,$smarty,$db;
    
    $sql = 'SELECT * FROM `payment` WHERE `payment_rand` = "'.$data[invoice_id].'" LIMIT 1;';
    $payment = $db->fetch($sql);
    
    $api = $data[api_key];
    $amount = $data[amount];
    $factorNumber = $data[invoice_id];
    $redirect = $data[callback].'&payid='.$payment['payment_id'];
    $result = Zardis_pay($api,$amount,$redirect);
    $result = json_decode($result,1);

    if($result['status'] == 1) {
        $update[payment_rand] = $result['invoice_key'];
        $sql = $db->queryUpdate('payment', $update, 'WHERE `payment_rand` = "'.$factorNumber.'" LIMIT 1;');
        $db->execute($sql);
        $go = "https://pay.zardis.net/invoice/pay/".$result['invoice_key'];
        header("Location: $go");
        exit;
    } else {
        //-- نمایش خطا
        $data[title] = 'خطای سیستم';
        $data[message] = '<font color="red">در ارتباط با درگاه مشکلی به وجود آمده است.</font> شماره خطا: '.$result['errorCode'].'<br />'.'متن خطا: '.$result['errorDescription'].'<br />'. '<a href="index.php" class="button">بازگشت</a>';
        $smarty->assign('data', $data);
        $smarty->display('message.tpl');
        exit;
    }
}

function callback__Zardis($data)
{
    global $db,$post,$smarty;
    $api = $data[api_key];
    
    $sql = 'SELECT * FROM `payment` WHERE `payment_rand` = "'.$post['invoice_key'].'" LIMIT 1;';
    $payment = $db->fetch($sql);
    if($payment) {
        if ($payment[payment_status] == 1) { // amadeye pardakht bude
            $result = Zardis_verify($api, $payment['payment_rand']);
            $result = json_decode($result,1);
            if($result['status'] == 1) {
                $output[status] = 1;
                $output[res_num] = NULL;
                $output[ref_num] = $result['bank_code'];
                $output[payment_id] = $payment[payment_id];
            } else {
                $output[status] = 0;
                $output[message] = 'تراکنش موفقیت آمیز نبود.';
            }
        } else {
            $output[status] = 0;
            $output[message] = 'چنین سفارشی تعریف نشده است.';
        }
    } else {
        $output[status]    = 0;
        $output[message]= 'اطلاعات پرداخت کامل نیست.';
    }
    return $output;
}