<?php
class osC_Payment_Zardis extends osC_Payment
{
    var $_title, $_code = 'Zardis', $_status = false, $_sort_order, $_order_id, $go;

    function send($api_key, $amount, $redirect)
    {
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,'https://pay.zardis.net/invoice/request');
        curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key&amount=$amount&return_url=$redirect");
        curl_setopt($ch,CURLOPT_POST,true);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }


    function verify($api_key, $inv_key)
    {
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,'https://pay.zardis.net/invoice/check/'.$inv_key);
        curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key");
        curl_setopt($ch,CURLOPT_POST,true);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }

    function osC_Payment_Zardis()
    {
        global $osC_Database, $osC_Language, $osC_ShoppingCart;
        $this->_title = $osC_Language->get('پرداخت اينترنتي Zardis');
        $this->_method_title = $osC_Language->get('پرداخت اينترنتي Zardis');
        $this->_status = (MODULE_PAYMENT_Zardis_STATUS == '1') ? true : false;
        $this->_sort_order = MODULE_PAYMENT_Zardis_SORT_ORDER;
        if ($this->_status === true) {
            if ((int)MODULE_PAYMENT_Zardis_ORDER_STATUS_ID > 0) {
                $this->order_status = MODULE_PAYMENT_Zardis_ORDER_STATUS_ID;
            }
            if ((int)MODULE_PAYMENT_Zardis_ZONE > 0) {
                $check_flag = false;
                $Qcheck = $osC_Database->query('select zone_id from :table_zones_to_geo_zones where geo_zone_id = :geo_zone_id and zone_country_id = :zone_country_id order by zone_id');
                $Qcheck->bindTable(':table_zones_to_geo_zones', TABLE_ZONES_TO_GEO_ZONES);
                $Qcheck->bindInt(':geo_zone_id', MODULE_PAYMENT_Zardis_ZONE);
                $Qcheck->bindInt(':zone_country_id', $osC_ShoppingCart->getBillingAddress('country_id'));
                $Qcheck->execute();
                while ($Qcheck->next()) {
                    if ($Qcheck->valueInt('zone_id') < 1) {
                        $check_flag = true;
                        break;
                    } elseif ($Qcheck->valueInt('zone_id') == $osC_ShoppingCart->getBillingAddress('zone_id')) {
                        $check_flag = true;
                        break;
                    }
                }
                if ($check_flag === false) {
                    $this->_status = false;
                }
            }
        }
    }

    function selection()
    {
        return array('id' => $this->_code, 'module' => $this->_method_title);
    }

    function pre_confirmation_check()
    {
        return false;
    }

    function confirmation()
    {
        global $osC_Language, $osC_CreditCard;
        $this->_order_id = osC_Order:: insert(ORDERS_STATUS_PREPARING);
        $confirmation = array('title' => $this->_method_title, 'fields' => array(array('title' => $osC_Language->get('پرداخت آنلاین توسط زردیس '))));

        return $confirmation;
    }

    function process_button()
    {
        global $osC_Currencies, $osC_ShoppingCart, $osC_Language, $osC_Database;
        if (MODULE_PAYMENT_Zardis_CURRENCY == 'Selected Currency') {
            $currency = $osC_Currencies->getCode();
        } else {
            $currency = MODULE_PAYMENT_Zardis_CURRENCY;
        }
        $amount = round($osC_Currencies->formatRaw($osC_ShoppingCart->getTotal(), $currency), 2);
        $order = $this->_order_id;
        $amount = $amount;
        $orderId = $order;
        $status = 1;
        $callbackUrl = urlencode(osc_href_link(FILENAME_CHECKOUT, 'process', 'HTTP', null, null, true));

        $api = MODULE_PAYMENT_Zardis_PIN;
        $result = $this->send($api, $amount, $callbackUrl);
        $result = json_decode($result);

        if ($result->status == 1) {
            $osC_Database->simpleQuery("insert into `" . DB_TABLE_PREFIX . "online_transactions`(orders_id,receipt_id,transaction_method,transaction_date,transaction_amount,transaction_id) values('$order','$result->invoice_key','Zardis','','$amount','')");
            echo '<div style="text-align:left;">' . osc_link_object(osc_href_link('https://pay.zardis.net/invoice/pay/' . $result->invoice_key, '', '', '', false), osc_draw_image_button('button_confirm_order.gif', $osC_Language->get('button_confirm_order'), 'id="btnConfirmOrder"')) . '</div><div style="display:none">';
        } else {
            osC_Order:: remove($this->_order_id);
            echo '<div style="font-size:11px; color:#cc0000; width:500px; border:1px solid #cc0000; padding:5px; background:#ffffcc;">' . $result->errorCode .':'.$result->errorDescription . '</div><div style="display:none">';
        }
    }

    function process()
    {
        global $osC_Language, $osC_Customer, $osC_ShoppingCart, $_POST, $_GET, $messageStack, $osC_Database;

        if ($_POST['status'] == 1) {
            $api = MODULE_PAYMENT_Zardis_PIN;
            $trans_id = $_POST['transId'];
            $result = $this->verify($api, $trans_id);
            $result = json_decode($result);

            if ($result->status == 1) {
                $order = $this->_order_id;

                $osC_Database->simpleQuery("update `" . DB_TABLE_PREFIX . "online_transactions` set transaction_id = '$trans_id',transaction_date = '" . date("YmdHis") . "' where 1 and ( receipt_id = '$trans_id' )");
                $Qtransaction = $osC_Database->query('insert into :table_orders_transactions_history (orders_id, transaction_code, transaction_return_value, transaction_return_status, date_added) values (:orders_id, :transaction_code, :transaction_return_value, :transaction_return_status, now())');
                $Qtransaction->bindTable(':table_orders_transactions_history', TABLE_ORDERS_TRANSACTIONS_HISTORY);
                $Qtransaction->bindInt(':orders_id', $order);
                $Qtransaction->bindInt(':transaction_code', 1);
                $Qtransaction->bindValue(':transaction_return_value', $trans_id);
                $Qtransaction->bindInt(':transaction_return_status', 1);
                $Qtransaction->execute();

                $this->_order_id = osC_Order:: insert();
                $comments = $osC_Language->get('payment_Zardis_method_authority') . '[' . $trans_id . ']';
                osC_Order:: process($this->_order_id, $this->order_status, $comments);
            } else {
                $order = $this->_order_id;
                $orderid = $order;
                $reversaltoreversal = $order;
                $reversalstatus = 1;
                $osC_Database->simpleQuery("delete from `" . DB_TABLE_PREFIX . "online_transactions` where 1 and ( receipt_id = '$trans_id' ) and ( orders_id = '$order' )");

                osC_Order:: remove($this->_order_id);
                $messageStack->add_session('checkout', 'خطا در تایید تراکنش ، مبلغ تراکنش با موفقیت به حساب شما برگشت داده شد.', 'error');
                osc_redirect(osc_href_link(FILENAME_CHECKOUT, 'checkout&view=paymentInformationForm', 'SSL', null, null, true));
            }
        } else {
            $order = $this->_order_id;
            $orderid = $order;
            $reversaltoreversal = $order;
            $reversalstatus = 1;
            $osC_Database->simpleQuery("delete from `" . DB_TABLE_PREFIX . "online_transactions` where 1 and ( orders_id = '$order' )");

            osC_Order:: remove($this->_order_id);
            $messageStack->add_session('checkout', 'خطا در تایید تراکنش ، مبلغ تراکنش با موفقیت به حساب شما برگشت داده شد.', 'error');
            osc_redirect(osc_href_link(FILENAME_CHECKOUT, 'checkout&view=paymentInformationForm', 'SSL', null, null, true));
        }
    }

    function callback()
    {
        global $osC_Database;
        //
    }
}